function load {
    stopsound @a master 
    scoreboard players set cutscene_active ak.state 0
    scoreboard players set time ak.state 90
    scoreboard players set power_time ak.state 0
    execute if score night_active ak.state matches 1 unless score manual_reload ak.state matches 1 run {
        scoreboard players set to_lobby ak.state 1
    }
    execute unless score manual_reload ak.state matches 1 run {
        scoreboard players set set_settings ak.state 1
    }
    scoreboard players set night_active ak.state 0
    scoreboard players set shutdown ak.state 0

    execute positioned -23.5 -59.5 193.3 run fill ~-10 -64 ~-10 ~10 ~10 ~10 light[level=8] replace light[level=0]
    execute positioned -23.5 -59.5 205.3 run fill ~-10 -64 ~-10 ~10 ~10 ~10 light[level=8] replace light[level=0]

    kill @e[tag=animatronic]
    kill @e[tag=freddy.body]

    scoreboard objectives add savegame dummy
    scoreboard players set gamemode save -1
    effect clear @a
    function animatronic:remix/reset
    function animatronic:classic/reset
    effect give @a minecraft:saturation 10 255 true
    scoreboard players set flashlight jc.temp 0
    execute as @e[tag=flashlight] run function animatronic:remix/flashlight/off
    scoreboard players set in_between_night_active ak.state 0
    # say Loaded fnaf

    kill @e[tag=freddie.eyes]
    kill @e[tag=bonnie.eyes]
    kill @e[tag=chica.eyes]
    kill @e[tag=foxy.eyes]
}

function reload {
    scoreboard players set shutdown ak.state 0

    execute positioned -23.5 -59.5 193.3 run fill ~-10 -64 ~-10 ~10 ~10 ~10 light[level=8] replace light[level=0]
    execute positioned -23.5 -59.5 205.3 run fill ~-10 -64 ~-10 ~10 ~10 ~10 light[level=8] replace light[level=0]

    kill @e[tag=animatronic]
    kill @e[tag=freddy.body]
}


function gameover {
    execute positioned 0 -60 0 run fill ~-10 -64 ~-10 ~10 ~10 ~10 black_concrete
    tag @a remove c
    execute at @a run summon enderman ~ ~ ~ {NoAI:1b, Silent:1b}
    gamemode spectator @a
    spectate @e[type=minecraft:enderman,limit=1] @p
    stopsound @a master
    schedule 5s replace {
        title @a actionbar {"text":"B","font":"cursor"}
        gamemode adventure @a
        execute positioned as @e[tag=lobby_spawn,limit=1] rotated 180 0 run tp @e[type=enderman] ~ ~ ~ ~ ~
        schedule 3t replace {
            function util:to_lobby
            tp @e[type=enderman] ~ -1000 ~
        }
    }
    time set midnight
}


function night_tick {
    execute if score night_active ak.state matches 1 run {
        execute if score power office_info matches 1.. run{
            execute if score usage office_info matches 0 if score power_time ak.state matches 10.. run {
                scoreboard players remove power office_info 1
                sequence {
                    execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_power_ui
                    delay 1t
                    kill @e[tag=ui]
                }
                scoreboard players set power_time ak.state 0
            }

            execute if score usage office_info matches 1 if score power_time ak.state matches 5.. run {
                scoreboard players remove power office_info 1
                sequence {
                    execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_power_ui
                    delay 1t
                    kill @e[tag=ui]
                }
                scoreboard players set power_time ak.state 0
            }

            execute if score usage office_info matches 2 if score power_time ak.state matches 2.. run {
                scoreboard players remove power office_info 1
                sequence {
                    execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_power_ui
                    delay 1t
                    kill @e[tag=ui]
                }
                scoreboard players set power_time ak.state 0
            }

            execute if score usage office_info matches 3.. if score power_time ak.state matches 1.. run {
                scoreboard players remove power office_info 1
                sequence {
                    execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_power_ui
                    delay 1t
                    kill @e[tag=ui]
                }
                scoreboard players set power_time ak.state 0
            }
        }
        
 
        execute if score hour office_info matches ..5 unless score shutdown ak.state matches 1 if score power office_info matches ..0 run {
            # no power left, shut down everything
            scoreboard players set shutdown ak.state 1
            stopsound @a master entity.pig.step
            stopsound @a master entity.ghast.hurt
            stopsound @a master entity.ghast.ambient
            stopsound @a master entity.ghast.scream
            stopsound @a master entity.ghast.warn
            stopsound @a master entity.ghast.death
            tag @e[tag=can_move] remove can_move
            tag @e[tag=can_kill] remove can_kill

            kill @e[tag=chica]
            kill @e[tag=bonnie]
            kill @e[tag=foxy]
            kill @e[tag=golden_freddy]

            execute if score inside_camera office_info matches 1 run {
                execute as @p at @s run playsound entity.wither.death master @a ~ ~ ~ 10000 1 1
	            execute as @p at @s run function util:reset_video_camera
	            execute as @p at @s run function util:office_camera_on_internal
            }
            
            function office:lights_off
            schedule 5t replace {
                function office:open_doors
            }

            execute positioned -23.5 -59.5 193.3 run playsound minecraft:entity.wolf.pant master @a ~ ~ ~ 10 1 1
            execute positioned -23.5 -59.5 193.3 run fill ~-10 -64 ~-10 ~10 ~10 ~10 light[level=0] replace light[level=8]
            execute positioned -23.5 -59.5 205.3 run fill ~-10 -64 ~-10 ~10 ~10 ~10 light[level=0] replace light[level=8]
            
            execute as @p at @s run function util:disable_shader

            schedule 5s replace {
                execute if score night_active ak.state matches 1 run function animatronic:classic/freddy/attack
            }
        }

        execute if score hour office_info matches ..6 if score time ak.state matches 0 run {
            scoreboard players set time ak.state 89
            scoreboard players add hour office_info 1
            sequence {
                execute as @p at @s run function util:update_time_ui
                delay 1t
                clear @p
            }
        }

        execute if score hour office_info matches 6.. run {
            kill @e[tag=animatronic]
            scoreboard players set night_active ak.state 0
            scoreboard players set in_between_night_active ak.state 1
            scoreboard players set hour office_info 0

            execute at @a run playsound entity.horse.death master @a
            title @a times 40t 80t 40t
            title @a subtitle {"text":"B","font":"cursor"}
            stopsound @a master entity.pig.step
            stopsound @a master entity.ghast.hurt
            stopsound @a master entity.ghast.ambient
            stopsound @a master entity.ghast.scream
            stopsound @a master entity.ghast.warn
            stopsound @a master entity.ghast.death
            stopsound @a master generic.ambient.fan
            function audio:ambient/stop
            sequence {
                title @a title ["",{"text":"\uEF00","font":"6am"},{"text":" AM","bold":true}]
                title @a subtitle {"text":"B","font":"cursor"}
                delay 2s
                title @a times 0t 10t 20t
                LOOP(72,i) {
                    title @a title ["",{"text":"\uEF<%i.toLocaleString('en-US',{minimumIntegerDigits:2,useGrouping:false})%>","font":"6am"},{"text":" AM","bold":true}]
                    title @a subtitle {"text":"B","font":"cursor"}
                    delay 1t
                }
                execute at @a run summon text_display ^ ^ ^1 {Tags:["black"],text:'{"text":"B","font":"cursor"}'}
                effect give @a blindness infinite 10 true
                LOOP(100,i) {
                    title @a title ["",{"text":"\uEF71","font":"6am"},{"text":" AM","bold":true}]
                    title @a subtitle {"text":"B","font":"cursor"}
                    delay 1t 
                }
                scoreboard players set manual_reload ak.state 1
                spawnpoint @a ~ ~ ~ ~
                function fnaf:progress_night
                execute at @a run summon text_display ^ ^ ^1 {Tags:["black"],text:'{"text":"B","font":"cursor"}'}
                effect give @a blindness infinite 10 true
                scoreboard players set manual_reload ak.state 0
                delay 3s
                effect clear @a blindness
                kill @e[tag=black]
                delay 10s
                title @a times 10t 70t 20t
            }
        }

        scoreboard players remove time ak.state 1
        scoreboard players add power_time ak.state 1
        execute if score night_active ak.state matches 1 run schedule function $block 1s replace
    }
}

function progress_night {
    function animatronic:classic/reset
    scoreboard players set night_selected ak.state 0
    execute if score night office_info matches 1 run {
        title @a times 40t 80t 40t
        title @a title ["",{"text":" 12:00  AM","font":"next_night_1"},{"text":"2nd Night","font":"next_night_2"}]
        title @a subtitle {"text":"B","font":"cursor"}
        schedule 40t replace {
            function fnaf:reload
            function office:load
            function util:load
            function cam:load
            function night:start_night_2
        }
        scoreboard players set night_selected ak.state 1
    }
    execute unless score night_selected ak.state matches 1 if score night office_info matches 2 run {
        title @a times 40t 80t 40t
        title @a title ["",{"text":" 12:00  AM","font":"next_night_1"},{"text":"3rd Night","font":"next_night_2"}]
        title @a subtitle {"text":"B","font":"cursor"}
        schedule 40t replace {
            function fnaf:reload
            function office:load
            function util:load
            function cam:load
            function night:start_night_3
        }
        scoreboard players set night_selected ak.state 1
    }
    execute unless score night_selected ak.state matches 1 if score night office_info matches 3 run {
        title @a times 40t 80t 40t
        title @a title ["",{"text":" 12:00  AM","font":"next_night_1"},{"text":"4th Night","font":"next_night_2"}]
        title @a subtitle {"text":"B","font":"cursor"}
        schedule 40t replace {
            function fnaf:reload
            function office:load
            function util:load
            function cam:load
            function night:start_night_4
        }
        scoreboard players set night_selected ak.state 1
    }
    execute unless score night_selected ak.state matches 1 if score night office_info matches 4 run {
        title @a times 40t 80t 40t
        title @a title ["",{"text":" 12:00  AM","font":"next_night_1"},{"text":"5th Night","font":"next_night_2"}]
        title @a subtitle {"text":"B","font":"cursor"}
        schedule 40t replace {
            function fnaf:reload
            function office:load
            function util:load
            function cam:load
            function night:start_night_5
        }
        scoreboard players set night_selected ak.state 1
    }
    # enable remix mode since the player beat classic mode
    execute unless score night_selected ak.state matches 1 if score night office_info matches 5 run {
        scoreboard players set night_selected ak.state 1
        scoreboard players set its_me ak.state 1
        # bring them back to the lobby
        function cutscene:cutscene_2_classic
    }
}

function start_night {
    gamemode adventure @p
    stopsound @a master entity.horse.death
    tag @a remove crosshair
    scoreboard players set time ak.state 90
    scoreboard players set power_time ak.state 0
    scoreboard players set night_active ak.state 1
    scoreboard players set hour office_info 0
    scoreboard players set power office_info 99
    scoreboard players set gamemode save 1
    scoreboard players set in_between_night_active ak.state 0
    execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_ui_state
    execute as @p at @s anchored eyes positioned ^ ^ ^ run function util:update_power_ui
    schedule 2t append {
        kill @e[tag=ui]
    }

    kill @e[tag=office_door]
    kill @e[tag=left_door]
    kill @e[tag=right_door]

    summon item_display -20.5 -58.5 195.0 {item:{id:"minecraft:fire_charge", Count:1b, tag:{CustomModelData:1118}}, Tags:["office","office_door","left_door"]}
	summon armor_stand -20.5 -58.5 195.0 {Marker:1b, Invisible:1b, Tags:["office", "left_door", "mount"]}
	ride @e[type=item_display,tag=left_door,limit=1] mount @e[type=armor_stand,tag=left_door,tag=mount,limit=1]

	summon item_display -26.5 -58.5 195.0 {item:{id:"minecraft:fire_charge", Count:1b, tag:{CustomModelData:1118}}, Tags:["office","office_door","right_door"], interpolation_duration:20}
	summon armor_stand -26.5 -58.5 195.0 {Marker:1b, Invisible:1b, Tags:["office", "right_door", "mount"]}
	ride @e[type=item_display,tag=right_door,limit=1] mount @e[type=armor_stand,tag=right_door,tag=mount,limit=1]

    # Open right door
    scoreboard players set right_door ak.state 0
	execute as @e[type=minecraft:armor_stand,tag=right_door,tag=mount] at @s run tp @s ~ ~3.1 ~
	fill -27 -60 195 -27 -58 194 minecraft:air
	item replace entity @e[type=item_display,tag=door_button,tag=right] container.0 with minecraft:fire_charge{CustomModelData:1105}

    # Open left door
	scoreboard players set left_door ak.state 0
	execute as @e[type=minecraft:armor_stand,tag=left_door,tag=mount] at @s run tp @s ~ ~3.1 ~
	fill -21 -60 194 -21 -58 195 minecraft:air
	item replace entity @e[type=item_display,tag=door_button,tag=left] container.0 with minecraft:fire_charge{CustomModelData:1105}
    
    function animatronic:classic/freddy/spawn
    function animatronic:classic/bonnie/spawn
    function animatronic:classic/chica/spawn
    function animatronic:classic/foxy/spawn
    

    scoreboard players set camera_state jc.temp 0

    execute if score compatibility ui matches 1 run bossbar set minecraft:main visible true

    execute if score compatibility ui matches 1 run schedule 5s append {
        execute if score compatibility ui matches 1 run bossbar set minecraft:main visible true
    }

    function fnaf:night_tick
}

function tick {
    execute as @a at @s if score to_lobby ak.state matches 1 run {
        scoreboard players set to_lobby ak.state 0
        function animatronic:remix/reset
        function util:to_lobby
    }

    scoreboard players operation old_usage office_info = usage office_info
    scoreboard players set usage office_info 0
    execute if score left_light ak.state matches 1 run scoreboard players add usage office_info 1
    execute if score left_door ak.state matches 1 run scoreboard players add usage office_info 1
    execute if score right_light ak.state matches 1 run scoreboard players add usage office_info 1
    execute if score right_door ak.state matches 1 run scoreboard players add usage office_info 1
    execute if score inside_camera office_info matches 1 run scoreboard players add usage office_info 1
    execute unless score old_usage office_info = usage office_info as @p at @s anchored eyes positioned ^ ^ ^ run{
        function util:update_usage_ui
        schedule 4t append {
            kill @e[tag=ui]
        }
    } 
}